// SPDX-FileCopyrightText: Copyright 2024 shadPS4 Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "core/libraries/error_codes.h"

// Libkernel library
constexpr int ORBIS_KERNEL_ERROR_UNKNOWN = 0x80020000;
constexpr int ORBIS_KERNEL_ERROR_EPERM = 0x80020001;
constexpr int ORBIS_KERNEL_ERROR_ENOENT = 0x80020002;
constexpr int ORBIS_KERNEL_ERROR_ESRCH = 0x80020003;
constexpr int ORBIS_KERNEL_ERROR_EINTR = 0x80020004;
constexpr int ORBIS_KERNEL_ERROR_EIO = 0x80020005;
constexpr int ORBIS_KERNEL_ERROR_ENXIO = 0x80020006;
constexpr int ORBIS_KERNEL_ERROR_E2BIG = 0x80020007;
constexpr int ORBIS_KERNEL_ERROR_ENOEXEC = 0x80020008;
constexpr int ORBIS_KERNEL_ERROR_EBADF = 0x80020009;
constexpr int ORBIS_KERNEL_ERROR_ECHILD = 0x8002000A;
constexpr int ORBIS_KERNEL_ERROR_EDEADLK = 0x8002000B;
constexpr int ORBIS_KERNEL_ERROR_ENOMEM = 0x8002000C;
constexpr int ORBIS_KERNEL_ERROR_EACCES = 0x8002000D;
constexpr int ORBIS_KERNEL_ERROR_EFAULT = 0x8002000E;
constexpr int ORBIS_KERNEL_ERROR_ENOTBLK = 0x8002000F;
constexpr int ORBIS_KERNEL_ERROR_EBUSY = 0x80020010;
constexpr int ORBIS_KERNEL_ERROR_EEXIST = 0x80020011;
constexpr int ORBIS_KERNEL_ERROR_EXDEV = 0x80020012;
constexpr int ORBIS_KERNEL_ERROR_ENODEV = 0x80020013;
constexpr int ORBIS_KERNEL_ERROR_ENOTDIR = 0x80020014;
constexpr int ORBIS_KERNEL_ERROR_EISDIR = 0x80020015;
constexpr int ORBIS_KERNEL_ERROR_EINVAL = 0x80020016;
constexpr int ORBIS_KERNEL_ERROR_ENFILE = 0x80020017;
constexpr int ORBIS_KERNEL_ERROR_EMFILE = 0x80020018;
constexpr int ORBIS_KERNEL_ERROR_ENOTTY = 0x80020019;
constexpr int ORBIS_KERNEL_ERROR_ETXTBSY = 0x8002001A;
constexpr int ORBIS_KERNEL_ERROR_EFBIG = 0x8002001B;
constexpr int ORBIS_KERNEL_ERROR_ENOSPC = 0x8002001C;
constexpr int ORBIS_KERNEL_ERROR_ESPIPE = 0x8002001D;
constexpr int ORBIS_KERNEL_ERROR_EROFS = 0x8002001E;
constexpr int ORBIS_KERNEL_ERROR_EMLINK = 0x8002001F;
constexpr int ORBIS_KERNEL_ERROR_EPIPE = 0x80020020;
constexpr int ORBIS_KERNEL_ERROR_EDOM = 0x80020021;
constexpr int ORBIS_KERNEL_ERROR_ERANGE = 0x80020022;
constexpr int ORBIS_KERNEL_ERROR_EAGAIN = 0x80020023;
constexpr int ORBIS_KERNEL_ERROR_EWOULDBLOCK = 0x80020023;
constexpr int ORBIS_KERNEL_ERROR_EINPROGRESS = 0x80020024;
constexpr int ORBIS_KERNEL_ERROR_EALREADY = 0x80020025;
constexpr int ORBIS_KERNEL_ERROR_ENOTSOCK = 0x80020026;
constexpr int ORBIS_KERNEL_ERROR_EDESTADDRREQ = 0x80020027;
constexpr int ORBIS_KERNEL_ERROR_EMSGSIZE = 0x80020028;
constexpr int ORBIS_KERNEL_ERROR_EPROTOTYPE = 0x80020029;
constexpr int ORBIS_KERNEL_ERROR_ENOPROTOOPT = 0x8002002A;
constexpr int ORBIS_KERNEL_ERROR_EPROTONOSUPPORT = 0x8002002B;
constexpr int ORBIS_KERNEL_ERROR_ESOCKTNOSUPPORT = 0x8002002C;
constexpr int ORBIS_KERNEL_ERROR_ENOTSUP = 0x8002002D;
constexpr int ORBIS_KERNEL_ERROR_EOPNOTSUPP = 0x8002002D;
constexpr int ORBIS_KERNEL_ERROR_EPFNOSUPPORT = 0x8002002E;
constexpr int ORBIS_KERNEL_ERROR_EAFNOSUPPORT = 0x8002002F;
constexpr int ORBIS_KERNEL_ERROR_EADDRINUSE = 0x80020030;
constexpr int ORBIS_KERNEL_ERROR_EADDRNOTAVAIL = 0x80020031;
constexpr int ORBIS_KERNEL_ERROR_ENETDOWN = 0x80020032;
constexpr int ORBIS_KERNEL_ERROR_ENETUNREACH = 0x80020033;
constexpr int ORBIS_KERNEL_ERROR_ENETRESET = 0x80020034;
constexpr int ORBIS_KERNEL_ERROR_ECONNABORTED = 0x80020035;
constexpr int ORBIS_KERNEL_ERROR_ECONNRESET = 0x80020036;
constexpr int ORBIS_KERNEL_ERROR_ENOBUFS = 0x80020037;
constexpr int ORBIS_KERNEL_ERROR_EISCONN = 0x80020038;
constexpr int ORBIS_KERNEL_ERROR_ENOTCONN = 0x80020039;
constexpr int ORBIS_KERNEL_ERROR_ESHUTDOWN = 0x8002003A;
constexpr int ORBIS_KERNEL_ERROR_ETOOMANYREFS = 0x8002003B;
constexpr int ORBIS_KERNEL_ERROR_ETIMEDOUT = 0x8002003C;
constexpr int ORBIS_KERNEL_ERROR_ECONNREFUSED = 0x8002003D;
constexpr int ORBIS_KERNEL_ERROR_ELOOP = 0x8002003E;
constexpr int ORBIS_KERNEL_ERROR_ENAMETOOLONG = 0x8002003F;
constexpr int ORBIS_KERNEL_ERROR_EHOSTDOWN = 0x80020040;
constexpr int ORBIS_KERNEL_ERROR_EHOSTUNREACH = 0x80020041;
constexpr int ORBIS_KERNEL_ERROR_ENOTEMPTY = 0x80020042;
constexpr int ORBIS_KERNEL_ERROR_EPROCLIM = 0x80020043;
constexpr int ORBIS_KERNEL_ERROR_EUSERS = 0x80020044;
constexpr int ORBIS_KERNEL_ERROR_EDQUOT = 0x80020045;
constexpr int ORBIS_KERNEL_ERROR_ESTALE = 0x80020046;
constexpr int ORBIS_KERNEL_ERROR_EREMOTE = 0x80020047;
constexpr int ORBIS_KERNEL_ERROR_EBADRPC = 0x80020048;
constexpr int ORBIS_KERNEL_ERROR_ERPCMISMATCH = 0x80020049;
constexpr int ORBIS_KERNEL_ERROR_EPROGUNAVAIL = 0x8002004A;
constexpr int ORBIS_KERNEL_ERROR_EPROGMISMATCH = 0x8002004B;
constexpr int ORBIS_KERNEL_ERROR_EPROCUNAVAIL = 0x8002004C;
constexpr int ORBIS_KERNEL_ERROR_ENOLCK = 0x8002004D;
constexpr int ORBIS_KERNEL_ERROR_ENOSYS = 0x8002004E;
constexpr int ORBIS_KERNEL_ERROR_EFTYPE = 0x8002004F;
constexpr int ORBIS_KERNEL_ERROR_EAUTH = 0x80020050;
constexpr int ORBIS_KERNEL_ERROR_ENEEDAUTH = 0x80020051;
constexpr int ORBIS_KERNEL_ERROR_EIDRM = 0x80020052;
constexpr int ORBIS_KERNEL_ERROR_ENOMSG = 0x80020053;
constexpr int ORBIS_KERNEL_ERROR_EOVERFLOW = 0x80020054;
constexpr int ORBIS_KERNEL_ERROR_ECANCELED = 0x80020055;
constexpr int ORBIS_KERNEL_ERROR_EILSEQ = 0x80020056;
constexpr int ORBIS_KERNEL_ERROR_ENOATTR = 0x80020057;
constexpr int ORBIS_KERNEL_ERROR_EDOOFUS = 0x80020058;
constexpr int ORBIS_KERNEL_ERROR_EBADMSG = 0x80020059;
constexpr int ORBIS_KERNEL_ERROR_EMULTIHOP = 0x8002005A;
constexpr int ORBIS_KERNEL_ERROR_ENOLINK = 0x8002005B;
constexpr int ORBIS_KERNEL_ERROR_EPROTO = 0x8002005C;
constexpr int ORBIS_KERNEL_ERROR_ENOTCAPABLE = 0x8002005D;
constexpr int ORBIS_KERNEL_ERROR_ECAPMODE = 0x8002005E;
constexpr int ORBIS_KERNEL_ERROR_ENOBLK = 0x8002005F;
constexpr int ORBIS_KERNEL_ERROR_EICV = 0x80020060;
constexpr int ORBIS_KERNEL_ERROR_ENOPLAYGOENT = 0x80020061;
