// SPDX-FileCopyrightText: Copyright 2024 shadPS4 Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "common/types.h"

namespace Core::Loader {
class SymbolsResolver;
}

namespace Libraries::Ssl {

struct OrbisSslCaCerts;

struct OrbisSslCaList {
    void* certs;
    int certsNum;
};

int PS4_SYSV_ABI CA_MGMT_allocCertDistinguishedName();
int PS4_SYSV_ABI CA_MGMT_certDistinguishedNameCompare();
int PS4_SYSV_ABI CA_MGMT_convertKeyBlobToPKCS8Key();
int PS4_SYSV_ABI CA_MGMT_convertKeyDER();
int PS4_SYSV_ABI CA_MGMT_convertKeyPEM();
int PS4_SYSV_ABI CA_MGMT_convertPKCS8KeyToKeyBlob();
int PS4_SYSV_ABI CA_MGMT_convertProtectedPKCS8KeyToKeyBlob();
int PS4_SYSV_ABI CA_MGMT_decodeCertificate();
int PS4_SYSV_ABI CA_MGMT_enumAltName();
int PS4_SYSV_ABI CA_MGMT_enumCrl();
int PS4_SYSV_ABI CA_MGMT_extractAllCertDistinguishedName();
int PS4_SYSV_ABI CA_MGMT_extractBasicConstraint();
int PS4_SYSV_ABI CA_MGMT_extractCertASN1Name();
int PS4_SYSV_ABI CA_MGMT_extractCertTimes();
int PS4_SYSV_ABI CA_MGMT_extractKeyBlobEx();
int PS4_SYSV_ABI CA_MGMT_extractKeyBlobTypeEx();
int PS4_SYSV_ABI CA_MGMT_extractPublicKeyInfo();
int PS4_SYSV_ABI CA_MGMT_extractSerialNum();
int PS4_SYSV_ABI CA_MGMT_extractSignature();
int PS4_SYSV_ABI CA_MGMT_free();
int PS4_SYSV_ABI CA_MGMT_freeCertDistinguishedName();
int PS4_SYSV_ABI CA_MGMT_freeCertDistinguishedNameOnStack();
int PS4_SYSV_ABI CA_MGMT_freeCertificate();
int PS4_SYSV_ABI CA_MGMT_freeKeyBlob();
int PS4_SYSV_ABI CA_MGMT_freeSearchDetails();
int PS4_SYSV_ABI CA_MGMT_getCertSignAlgoType();
int PS4_SYSV_ABI CA_MGMT_keyBlobToDER();
int PS4_SYSV_ABI CA_MGMT_keyBlobToPEM();
int PS4_SYSV_ABI CA_MGMT_makeKeyBlobEx();
int PS4_SYSV_ABI CA_MGMT_rawVerifyOID();
int PS4_SYSV_ABI CA_MGMT_reorderChain();
int PS4_SYSV_ABI CA_MGMT_returnCertificatePrints();
int PS4_SYSV_ABI CA_MGMT_verifyCertWithKeyBlob();
int PS4_SYSV_ABI CA_MGMT_verifySignature();
int PS4_SYSV_ABI CERT_checkCertificateIssuer();
int PS4_SYSV_ABI CERT_checkCertificateIssuer2();
int PS4_SYSV_ABI CERT_checkCertificateIssuerSerialNumber();
int PS4_SYSV_ABI CERT_CompSubjectAltNames();
int PS4_SYSV_ABI CERT_CompSubjectAltNames2();
int PS4_SYSV_ABI CERT_CompSubjectAltNamesExact();
int PS4_SYSV_ABI CERT_CompSubjectCommonName();
int PS4_SYSV_ABI CERT_CompSubjectCommonName2();
int PS4_SYSV_ABI CERT_ComputeBufferHash();
int PS4_SYSV_ABI CERT_decryptRSASignature();
int PS4_SYSV_ABI CERT_decryptRSASignatureBuffer();
int PS4_SYSV_ABI CERT_enumerateAltName();
int PS4_SYSV_ABI CERT_enumerateAltName2();
int PS4_SYSV_ABI CERT_enumerateCRL();
int PS4_SYSV_ABI CERT_enumerateCRL2();
int PS4_SYSV_ABI CERT_enumerateCRLAux();
int PS4_SYSV_ABI CERT_extractAllDistinguishedNames();
int PS4_SYSV_ABI CERT_extractDistinguishedNames();
int PS4_SYSV_ABI CERT_extractDistinguishedNames2();
int PS4_SYSV_ABI CERT_extractDistinguishedNamesFromName();
int PS4_SYSV_ABI CERT_extractRSAKey();
int PS4_SYSV_ABI CERT_extractSerialNum();
int PS4_SYSV_ABI CERT_extractSerialNum2();
int PS4_SYSV_ABI CERT_extractValidityTime();
int PS4_SYSV_ABI CERT_extractValidityTime2();
int PS4_SYSV_ABI CERT_getCertExtension();
int PS4_SYSV_ABI CERT_getCertificateExtensions();
int PS4_SYSV_ABI CERT_getCertificateExtensions2();
int PS4_SYSV_ABI CERT_getCertificateIssuerSerialNumber();
int PS4_SYSV_ABI CERT_getCertificateIssuerSerialNumber2();
int PS4_SYSV_ABI CERT_getCertificateKeyUsage();
int PS4_SYSV_ABI CERT_getCertificateKeyUsage2();
int PS4_SYSV_ABI CERT_getCertificateSubject();
int PS4_SYSV_ABI CERT_getCertificateSubject2();
int PS4_SYSV_ABI CERT_getCertSignAlgoType();
int PS4_SYSV_ABI CERT_GetCertTime();
int PS4_SYSV_ABI CERT_getNumberOfChild();
int PS4_SYSV_ABI CERT_getRSASignatureAlgo();
int PS4_SYSV_ABI CERT_getSignatureItem();
int PS4_SYSV_ABI CERT_getSubjectCommonName();
int PS4_SYSV_ABI CERT_getSubjectCommonName2();
int PS4_SYSV_ABI CERT_isRootCertificate();
int PS4_SYSV_ABI CERT_isRootCertificate2();
int PS4_SYSV_ABI CERT_rawVerifyOID();
int PS4_SYSV_ABI CERT_rawVerifyOID2();
int PS4_SYSV_ABI CERT_setKeyFromSubjectPublicKeyInfo();
int PS4_SYSV_ABI CERT_setKeyFromSubjectPublicKeyInfoCert();
int PS4_SYSV_ABI CERT_STORE_addCertAuthority();
int PS4_SYSV_ABI CERT_STORE_addIdentity();
int PS4_SYSV_ABI CERT_STORE_addIdentityNakedKey();
int PS4_SYSV_ABI CERT_STORE_addIdentityPSK();
int PS4_SYSV_ABI CERT_STORE_addIdentityWithCertificateChain();
int PS4_SYSV_ABI CERT_STORE_addTrustPoint();
int PS4_SYSV_ABI CERT_STORE_createStore();
int PS4_SYSV_ABI CERT_STORE_findCertBySubject();
int PS4_SYSV_ABI CERT_STORE_findIdentityByTypeFirst();
int PS4_SYSV_ABI CERT_STORE_findIdentityByTypeNext();
int PS4_SYSV_ABI CERT_STORE_findIdentityCertChainFirst();
int PS4_SYSV_ABI CERT_STORE_findIdentityCertChainNext();
int PS4_SYSV_ABI CERT_STORE_findPskByIdentity();
int PS4_SYSV_ABI CERT_STORE_releaseStore();
int PS4_SYSV_ABI CERT_STORE_traversePskListHead();
int PS4_SYSV_ABI CERT_STORE_traversePskListNext();
int PS4_SYSV_ABI CERT_validateCertificate();
int PS4_SYSV_ABI CERT_validateCertificateWithConf();
int PS4_SYSV_ABI CERT_VerifyCertificatePolicies();
int PS4_SYSV_ABI CERT_VerifyCertificatePolicies2();
int PS4_SYSV_ABI CERT_verifySignature();
int PS4_SYSV_ABI CERT_VerifyValidityTime();
int PS4_SYSV_ABI CERT_VerifyValidityTime2();
int PS4_SYSV_ABI CERT_VerifyValidityTimeWithConf();
int PS4_SYSV_ABI CRYPTO_initAsymmetricKey();
int PS4_SYSV_ABI CRYPTO_uninitAsymmetricKey();
int PS4_SYSV_ABI GC_createInstanceIDs();
int PS4_SYSV_ABI getCertSigAlgo();
int PS4_SYSV_ABI MOCANA_freeMocana();
int PS4_SYSV_ABI MOCANA_initMocana();
int PS4_SYSV_ABI RSA_verifySignature();
int PS4_SYSV_ABI sceSslCheckRecvPending();
int PS4_SYSV_ABI sceSslClose();
int PS4_SYSV_ABI sceSslConnect();
int PS4_SYSV_ABI sceSslCreateSslConnection();
int PS4_SYSV_ABI sceSslDeleteSslConnection();
int PS4_SYSV_ABI sceSslDisableOption();
int PS4_SYSV_ABI sceSslDisableOptionInternal();
int PS4_SYSV_ABI sceSslDisableOptionInternalInsecure();
int PS4_SYSV_ABI sceSslEnableOption();
int PS4_SYSV_ABI sceSslEnableOptionInternal();
int PS4_SYSV_ABI sceSslFreeCaCerts();
int PS4_SYSV_ABI sceSslFreeCaList();
int PS4_SYSV_ABI sceSslFreeSslCertName();
int PS4_SYSV_ABI sceSslGetCaCerts(int sslCtxId, OrbisSslCaCerts* certs);
int PS4_SYSV_ABI sceSslGetCaList();
int PS4_SYSV_ABI sceSslGetIssuerName();
int PS4_SYSV_ABI sceSslGetMemoryPoolStats();
int PS4_SYSV_ABI sceSslGetNameEntryCount();
int PS4_SYSV_ABI sceSslGetNameEntryInfo();
int PS4_SYSV_ABI sceSslGetNanoSSLModuleId();
int PS4_SYSV_ABI sceSslGetNotAfter();
int PS4_SYSV_ABI sceSslGetNotBefore();
int PS4_SYSV_ABI sceSslGetSerialNumber();
int PS4_SYSV_ABI sceSslGetSslError();
int PS4_SYSV_ABI sceSslGetSubjectName();
int PS4_SYSV_ABI sceSslInit(std::size_t poolSize);
int PS4_SYSV_ABI sceSslLoadCert();
int PS4_SYSV_ABI sceSslLoadRootCACert();
int PS4_SYSV_ABI sceSslRecv();
int PS4_SYSV_ABI sceSslReuseConnection();
int PS4_SYSV_ABI sceSslSend();
int PS4_SYSV_ABI sceSslSetMinSslVersion();
int PS4_SYSV_ABI sceSslSetSslVersion();
int PS4_SYSV_ABI sceSslSetVerifyCallback();
int PS4_SYSV_ABI sceSslShowMemoryStat();
int PS4_SYSV_ABI sceSslTerm();
int PS4_SYSV_ABI sceSslUnloadCert();
int PS4_SYSV_ABI SSL_acceptConnection();
int PS4_SYSV_ABI SSL_acceptConnectionCommon();
int PS4_SYSV_ABI SSL_assignCertificateStore();
int PS4_SYSV_ABI SSL_ASYNC_acceptConnection();
int PS4_SYSV_ABI SSL_ASYNC_closeConnection();
int PS4_SYSV_ABI SSL_ASYNC_connect();
int PS4_SYSV_ABI SSL_ASYNC_connectCommon();
int PS4_SYSV_ABI SSL_ASYNC_getRecvBuffer();
int PS4_SYSV_ABI SSL_ASYNC_getSendBuffer();
int PS4_SYSV_ABI SSL_ASYNC_init();
int PS4_SYSV_ABI SSL_ASYNC_initServer();
int PS4_SYSV_ABI SSL_ASYNC_recvMessage();
int PS4_SYSV_ABI SSL_ASYNC_recvMessage2();
int PS4_SYSV_ABI SSL_ASYNC_sendMessage();
int PS4_SYSV_ABI SSL_ASYNC_sendMessagePending();
int PS4_SYSV_ABI SSL_ASYNC_start();
int PS4_SYSV_ABI SSL_closeConnection();
int PS4_SYSV_ABI SSL_connect();
int PS4_SYSV_ABI SSL_connectWithCfgParam();
int PS4_SYSV_ABI SSL_enableCiphers();
int PS4_SYSV_ABI SSL_findConnectionInstance();
int PS4_SYSV_ABI SSL_getCipherInfo();
int PS4_SYSV_ABI SSL_getClientRandom();
int PS4_SYSV_ABI SSL_getClientSessionInfo();
int PS4_SYSV_ABI SSL_getCookie();
int PS4_SYSV_ABI SSL_getNextSessionId();
int PS4_SYSV_ABI SSL_getServerRandom();
int PS4_SYSV_ABI SSL_getSessionCache();
int PS4_SYSV_ABI SSL_getSessionFlags();
int PS4_SYSV_ABI SSL_getSessionInfo();
int PS4_SYSV_ABI SSL_getSessionStatus();
int PS4_SYSV_ABI SSL_getSocketId();
int PS4_SYSV_ABI SSL_getSSLTLSVersion();
int PS4_SYSV_ABI SSL_init();
int PS4_SYSV_ABI SSL_initiateRehandshake();
int PS4_SYSV_ABI SSL_initServerCert();
int PS4_SYSV_ABI SSL_ioctl();
int PS4_SYSV_ABI SSL_isSessionSSL();
int PS4_SYSV_ABI SSL_lockSessionCacheMutex();
int PS4_SYSV_ABI SSL_lookupAlert();
int PS4_SYSV_ABI SSL_negotiateConnection();
int PS4_SYSV_ABI SSL_recv();
int PS4_SYSV_ABI SSL_recvPending();
int PS4_SYSV_ABI SSL_releaseTables();
int PS4_SYSV_ABI SSL_retrieveServerNameList();
int PS4_SYSV_ABI SSL_rngFun();
int PS4_SYSV_ABI SSL_send();
int PS4_SYSV_ABI SSL_sendAlert();
int PS4_SYSV_ABI SSL_sendPending();
int PS4_SYSV_ABI SSL_setCookie();
int PS4_SYSV_ABI SSL_setServerCert();
int PS4_SYSV_ABI SSL_setServerNameList();
int PS4_SYSV_ABI SSL_setSessionFlags();
int PS4_SYSV_ABI SSL_shutdown();
int PS4_SYSV_ABI SSL_sslSettings();
int PS4_SYSV_ABI SSL_validateCertParam();
int PS4_SYSV_ABI VLONG_freeVlongQueue();
int PS4_SYSV_ABI Func_22E76E60BC0587D7();
int PS4_SYSV_ABI Func_28F8791A771D39C7();

void RegisterLib(Core::Loader::SymbolsResolver* sym);
} // namespace Libraries::Ssl
