// SPDX-FileCopyrightText: Copyright 2024 shadPS4 Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "core/libraries/error_codes.h"

// VideoOut library
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_VALUE = 0x80290001;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_ADDRESS = 0x80290002;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_PIXEL_FORMAT = 0x80290003;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_PITCH = 0x80290004;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_RESOLUTION = 0x80290005;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_FLIP_MODE = 0x80290006;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_TILING_MODE = 0x80290007;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_ASPECT_RATIO = 0x80290008;
constexpr int ORBIS_VIDEO_OUT_ERROR_RESOURCE_BUSY = 0x80290009;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_INDEX = 0x8029000A;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_HANDLE = 0x8029000B;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_EVENT_QUEUE = 0x8029000C;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_EVENT = 0x8029000D;
constexpr int ORBIS_VIDEO_OUT_ERROR_NO_EMPTY_SLOT = 0x8029000F;
constexpr int ORBIS_VIDEO_OUT_ERROR_SLOT_OCCUPIED = 0x80290010;
constexpr int ORBIS_VIDEO_OUT_ERROR_FLIP_QUEUE_FULL = 0x80290012;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_MEMORY = 0x80290013;
constexpr int ORBIS_VIDEO_OUT_ERROR_MEMORY_NOT_PHYSICALLY_CONTIGUOUS = 0x80290014;
constexpr int ORBIS_VIDEO_OUT_ERROR_MEMORY_INVALID_ALIGNMENT = 0x80290015;
constexpr int ORBIS_VIDEO_OUT_ERROR_UNSUPPORTED_OUTPUT_MODE = 0x80290016;
constexpr int ORBIS_VIDEO_OUT_ERROR_OVERFLOW = 0x80290017;
constexpr int ORBIS_VIDEO_OUT_ERROR_NO_DEVICE = 0x80290018;
constexpr int ORBIS_VIDEO_OUT_ERROR_UNAVAILABLE_OUTPUT_MODE = 0x80290019;
constexpr int ORBIS_VIDEO_OUT_ERROR_INVALID_OPTION = 0x8029001A;
constexpr int ORBIS_VIDEO_OUT_ERROR_UNKNOWN = 0x802900FE;
constexpr int ORBIS_VIDEO_OUT_ERROR_FATAL = 0x802900FF;
constexpr int ORBIS_VIDEO_OUT_ERROR_ENOMEM = 0x8029100C;
