// SPDX-FileCopyrightText: Copyright 2024 shadPS4 Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#include <string>

#include "common/scm_rev.h"

namespace Common {

constexpr char g_version[]  = "0.11.1 WIP";
constexpr bool g_is_release = false;

constexpr char g_scm_rev[]         = "2d17ab8e4bac0b2a626ab23e0ebc62b8edb6059f";
constexpr char g_scm_branch[]      = "main";
constexpr char g_scm_desc[]        = "v.0.11.0-69-g2d17ab8e4-dirty";
constexpr char g_scm_remote_name[] = "origin";
constexpr char g_scm_remote_url[]  = "https://aur.archlinux.org/shadps4-git.git";
constexpr char g_scm_date[]        = "2025-10-20 14:04:56";

const std::string GetRemoteNameFromLink() {
    std::string remote_url(Common::g_scm_remote_url);
    std::string remote_host;
    try {
        if (remote_url.starts_with("http")) {
            if (*remote_url.rbegin() == '/') {
                remote_url.pop_back();
            }
            remote_host = remote_url.substr(19, remote_url.rfind('/') - 19);
        } else if (remote_url.starts_with("git@")) {
            auto after_comma_pos = remote_url.find(':') + 1, slash_pos = remote_url.find('/');
            remote_host = remote_url.substr(after_comma_pos, slash_pos - after_comma_pos);
        } else {
            remote_host = "unknown";
        }
    } catch (...) {
        remote_host = "unknown";
    }
    return remote_host;
}

} // namespace

