// SPDX-FileCopyrightText: Copyright 2024 shadPS4 Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "core/libraries/error_codes.h"

// ImeDialog library
constexpr int ORBIS_ERROR_DIALOG_ERROR_NOT_INITIALIZED = 0x80ED0001;
constexpr int ORBIS_ERROR_DIALOG_ERROR_ALREADY_INITIALIZED = 0x80ED0002;
constexpr int ORBIS_ERROR_DIALOG_ERROR_PARAM_INVALID = 0x80ED0003;
constexpr int ORBIS_ERROR_DIALOG_ERROR_UNEXPECTED_FATAL = 0x80ED0004;
constexpr int ORBIS_ERROR_DIALOG_ERROR_INVALID_STATE = 0x80ED0005;
constexpr int ORBIS_ERROR_DIALOG_ERROR_SERVICE_BUSY = 0x80ED0006;
constexpr int ORBIS_ERROR_DIALOG_ERROR_INVALID_USER_ID = 0x80ED0007;

// Ime library
constexpr int ORBIS_IME_ERROR_BUSY = 0x80BC0001;
constexpr int ORBIS_IME_ERROR_NOT_OPENED = 0x80BC0002;
constexpr int ORBIS_IME_ERROR_NO_MEMORY = 0x80BC0003;
constexpr int ORBIS_IME_ERROR_CONNECTION_FAILED = 0x80BC0004;
constexpr int ORBIS_IME_ERROR_TOO_MANY_REQUESTS = 0x80BC0005;
constexpr int ORBIS_IME_ERROR_INVALID_TEXT = 0x80BC0006;
constexpr int ORBIS_IME_ERROR_EVENT_OVERFLOW = 0x80BC0007;
constexpr int ORBIS_IME_ERROR_NOT_ACTIVE = 0x80BC0008;
constexpr int ORBIS_IME_ERROR_IME_SUSPENDING = 0x80BC0009;
constexpr int ORBIS_IME_ERROR_DEVICE_IN_USE = 0x80BC000A;
constexpr int ORBIS_IME_ERROR_INVALID_USER_ID = 0x80BC0010;
constexpr int ORBIS_IME_ERROR_INVALID_TYPE = 0x80BC0011;
constexpr int ORBIS_IME_ERROR_INVALID_SUPPORTED_LANGUAGES = 0x80BC0012;
constexpr int ORBIS_IME_ERROR_INVALID_ENTER_LABEL = 0x80BC0013;
constexpr int ORBIS_IME_ERROR_INVALID_INPUT_METHOD = 0x80BC0014;
constexpr int ORBIS_IME_ERROR_INVALID_OPTION = 0x80BC0015;
constexpr int ORBIS_IME_ERROR_INVALID_MAX_TEXT_LENGTH = 0x80BC0016;
constexpr int ORBIS_IME_ERROR_INVALID_INPUT_TEXT_BUFFER = 0x80BC0017;
constexpr int ORBIS_IME_ERROR_INVALID_POSX = 0x80BC0018;
constexpr int ORBIS_IME_ERROR_INVALID_POSY = 0x80BC0019;
constexpr int ORBIS_IME_ERROR_INVALID_HORIZONTAL_ALIGNMENT = 0x80BC001A;
constexpr int ORBIS_IME_ERROR_INVALID_VERTICAL_ALIGNMENT = 0x80BC001B;
constexpr int ORBIS_IME_ERROR_INVALID_EXTENDED = 0x80BC001C;
constexpr int ORBIS_IME_ERROR_INVALID_KEYBOARD_TYPE = 0x80BC001D;
constexpr int ORBIS_IME_ERROR_INVALID_WORK = 0x80BC0020;
constexpr int ORBIS_IME_ERROR_INVALID_ARG = 0x80BC0021;
constexpr int ORBIS_IME_ERROR_INVALID_HANDLER = 0x80BC0022;
constexpr int ORBIS_IME_ERROR_NO_RESOURCE_ID = 0x80BC0023;
constexpr int ORBIS_IME_ERROR_INVALID_MODE = 0x80BC0024;
constexpr int ORBIS_IME_ERROR_INVALID_PARAM = 0x80BC0030;
constexpr int ORBIS_IME_ERROR_INVALID_ADDRESS = 0x80BC0031;
constexpr int ORBIS_IME_ERROR_INVALID_RESERVED = 0x80BC0032;
constexpr int ORBIS_IME_ERROR_INVALID_TIMING = 0x80BC0033;
constexpr int ORBIS_IME_ERROR_INTERNAL = 0x80BC00FF;
