// SPDX-FileCopyrightText: Copyright 2024 shadPS4 Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "core/libraries/error_codes.h"

constexpr int ORBIS_HTTP_ERROR_BEFORE_INIT = 0x80431001;
constexpr int ORBIS_HTTP_ERROR_ALREADY_INITED = 0x80431020;
constexpr int ORBIS_HTTP_ERROR_BUSY = 0x80431021;
constexpr int ORBIS_HTTP_ERROR_OUT_OF_MEMORY = 0x80431022;
constexpr int ORBIS_HTTP_ERROR_NOT_FOUND = 0x80431025;
constexpr int ORBIS_HTTP_ERROR_INVALID_VERSION = 0x8043106a;
constexpr int ORBIS_HTTP_ERROR_INVALID_ID = 0x80431100;
constexpr int ORBIS_HTTP_ERROR_OUT_OF_SIZE = 0x80431104;
constexpr int ORBIS_HTTP_ERROR_INVALID_VALUE = 0x804311fe;

constexpr int ORBIS_HTTP_ERROR_INVALID_URL = 0x80433060;
constexpr int ORBIS_HTTP_ERROR_UNKNOWN_SCHEME = 0x80431061;
constexpr int ORBIS_HTTP_ERROR_NETWORK = 0x80431063;
constexpr int ORBIS_HTTP_ERROR_BAD_RESPONSE = 0x80431064;
constexpr int ORBIS_HTTP_ERROR_BEFORE_SEND = 0x80431065;
constexpr int ORBIS_HTTP_ERROR_AFTER_SEND = 0x80431066;
constexpr int ORBIS_HTTP_ERROR_TIMEOUT = 0x80431068;
constexpr int ORBIS_HTTP_ERROR_UNKNOWN_AUTH_TYPE = 0x80431069;
constexpr int ORBIS_HTTP_ERROR_UNKNOWN_METHOD = 0x8043106b;
constexpr int ORBIS_HTTP_ERROR_READ_BY_HEAD_METHOD = 0x8043106f;
constexpr int ORBIS_HTTP_ERROR_NOT_IN_COM = 0x80431070;
constexpr int ORBIS_HTTP_ERROR_NO_CONTENT_LENGTH = 0x80431071;
constexpr int ORBIS_HTTP_ERROR_CHUNK_ENC = 0x80431072;
constexpr int ORBIS_HTTP_ERROR_TOO_LARGE_RESPONSE_HEADER = 0x80431073;
constexpr int ORBIS_HTTP_ERROR_SSL = 0x80431075;
constexpr int ORBIS_HTTP_ERROR_INSUFFICIENT_STACKSIZE = 0x80431076;
constexpr int ORBIS_HTTP_ERROR_ABORTED = 0x80431080;
constexpr int ORBIS_HTTP_ERROR_UNKNOWN = 0x80431081;
constexpr int ORBIS_HTTP_ERROR_EAGAIN = 0x80431082;
constexpr int ORBIS_HTTP_ERROR_PROXY = 0x80431084;
constexpr int ORBIS_HTTP_ERROR_BROKEN = 0x80431085;

constexpr int ORBIS_HTTP_ERROR_PARSE_HTTP_NOT_FOUND = 0x80432025;
constexpr int ORBIS_HTTP_ERROR_PARSE_HTTP_INVALID_RESPONSE = 0x80432060;
constexpr int ORBIS_HTTP_ERROR_PARSE_HTTP_INVALID_VALUE = 0x804321fe;

constexpr int ORBIS_HTTP_ERROR_RESOLVER_EPACKET = 0x80436001;
constexpr int ORBIS_HTTP_ERROR_RESOLVER_ENODNS = 0x80436002;
constexpr int ORBIS_HTTP_ERROR_RESOLVER_ETIMEDOUT = 0x80436003;
constexpr int ORBIS_HTTP_ERROR_RESOLVER_ENOSUPPORT = 0x80436004;
constexpr int ORBIS_HTTP_ERROR_RESOLVER_EFORMAT = 0x80436005;
constexpr int ORBIS_HTTP_ERROR_RESOLVER_ESERVERFAILURE = 0x80436006;
constexpr int ORBIS_HTTP_ERROR_RESOLVER_ENOHOST = 0x80436007;
constexpr int ORBIS_HTTP_ERROR_RESOLVER_ENOTIMPLEMENTED = 0x80436008;
constexpr int ORBIS_HTTP_ERROR_RESOLVER_ESERVERREFUSED = 0x80436009;
constexpr int ORBIS_HTTP_ERROR_RESOLVER_ENORECORD = 0x8043600a;

constexpr int ORBIS_HTTPS_ERROR_CERT = 0x80435060;
constexpr int ORBIS_HTTPS_ERROR_HANDSHAKE = 0x80435061;
constexpr int ORBIS_HTTPS_ERROR_IO = 0x80435062;
constexpr int ORBIS_HTTPS_ERROR_INTERNAL = 0x80435063;
constexpr int ORBIS_HTTPS_ERROR_PROXY = 0x80435064;

constexpr int ORBIS_HTTPS_ERROR_SSL_INTERNAL = 0x01;
constexpr int ORBIS_HTTPS_ERROR_SSL_INVALID_CERT = 0x02;
constexpr int ORBIS_HTTPS_ERROR_SSL_CN_CHECK = 0x04;
constexpr int ORBIS_HTTPS_ERROR_SSL_NOT_AFTER_CHECK = 0x08;
constexpr int ORBIS_HTTPS_ERROR_SSL_NOT_BEFORE_CHECK = 0x10;
constexpr int ORBIS_HTTPS_ERROR_SSL_UNKNOWN_CA = 0x20;
