// SPDX-FileCopyrightText: Copyright 2024 shadPS4 Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

//     opcode name,                                         return type,    arg1 type,      arg2 type,      arg3 type,      arg4 type,      arg4 type,      ...
OPCODE(Phi,                                                 Opaque,                                                                                         )
OPCODE(Identity,                                            Opaque,         Opaque,                                                                         )
OPCODE(Void,                                                Void,                                                                                           )
OPCODE(ConditionRef,                                        U1,             U1,                                                                             )
OPCODE(Reference,                                           Void,           Opaque,                                                                         )
OPCODE(PhiMove,                                             Void,           Opaque,         Opaque,                                                         )

// Special operations
OPCODE(Prologue,                                            Void,                                                                                           )
OPCODE(Epilogue,                                            Void,                                                                                           )
OPCODE(Discard,                                             Void,                                                                                           )
OPCODE(DiscardCond,                                         Void,           U1,                                                                             )
OPCODE(DebugPrint,                                          Void,           StringLiteral,  Opaque,          Opaque,        Opaque,         Opaque,         )

// Constant memory operations
OPCODE(ReadConst,                                           U32,            U32x2,          U32,                                                            )
OPCODE(ReadConstBuffer,                                     U32,            Opaque,         U32,                                                            )

// Barriers
OPCODE(Barrier,                                             Void,                                                                                           )
OPCODE(WorkgroupMemoryBarrier,                              Void,                                                                                           )
OPCODE(DeviceMemoryBarrier,                                 Void,                                                                                           )

// Geometry shader specific
OPCODE(EmitVertex,                                          Void,                                                                                           )
OPCODE(EmitPrimitive,                                       Void,                                                                                           )

// Shared memory operations
OPCODE(LoadSharedU16,                                       U16,            U32,                                                                            )
OPCODE(LoadSharedU32,                                       U32,            U32,                                                                            )
OPCODE(LoadSharedU64,                                       U64,            U32,                                                                            )
OPCODE(WriteSharedU16,                                      Void,           U32,            U16,                                                            )
OPCODE(WriteSharedU32,                                      Void,           U32,            U32,                                                            )
OPCODE(WriteSharedU64,                                      Void,           U32,            U64,                                                            )

// Shared atomic operations
OPCODE(SharedAtomicIAdd32,                                  U32,            U32,            U32,                                                            )
OPCODE(SharedAtomicIAdd64,                                  U64,            U32,            U64,                                                            )
OPCODE(SharedAtomicISub32,                                  U32,            U32,            U32,                                                            )
OPCODE(SharedAtomicISub64,                                  U64,            U32,            U64,                                                            )
OPCODE(SharedAtomicSMin32,                                  U32,            U32,            U32,                                                            )
OPCODE(SharedAtomicSMin64,                                  U64,            U32,            U64,                                                            )
OPCODE(SharedAtomicUMin32,                                  U32,            U32,            U32,                                                            )
OPCODE(SharedAtomicUMin64,                                  U64,            U32,            U64,                                                            )
OPCODE(SharedAtomicSMax32,                                  U32,            U32,            U32,                                                            )
OPCODE(SharedAtomicSMax64,                                  U64,            U32,            U64,                                                            )
OPCODE(SharedAtomicUMax32,                                  U32,            U32,            U32,                                                            )
OPCODE(SharedAtomicUMax64,                                  U64,            U32,            U64,                                                            )
OPCODE(SharedAtomicInc32,                                   U32,            U32,                                                                            )
OPCODE(SharedAtomicInc64,                                   U64,            U32,                                                                            )
OPCODE(SharedAtomicDec32,                                   U32,            U32,                                                                            )
OPCODE(SharedAtomicDec64,                                   U64,            U32,                                                                            )
OPCODE(SharedAtomicAnd32,                                   U32,            U32,            U32,                                                            )
OPCODE(SharedAtomicAnd64,                                   U64,            U32,            U64,                                                            )
OPCODE(SharedAtomicOr32,                                    U32,            U32,            U32,                                                            )
OPCODE(SharedAtomicOr64,                                    U64,            U32,            U64,                                                            )
OPCODE(SharedAtomicXor32,                                   U32,            U32,            U32,                                                            )
OPCODE(SharedAtomicXor64,                                   U64,            U32,            U64,                                                            )

// Context getters/setters
OPCODE(GetUserData,                                         U32,            ScalarReg,                                                                      )
OPCODE(GetThreadBitScalarReg,                               U1,             ScalarReg,                                                                      )
OPCODE(SetThreadBitScalarReg,                               Void,           ScalarReg,      U1,                                                             )
OPCODE(GetScalarRegister,                                   U32,            ScalarReg,                                                                      )
OPCODE(SetScalarRegister,                                   Void,           ScalarReg,      U32,                                                            )
OPCODE(GetVectorRegister,                                   U32,            VectorReg,                                                                      )
OPCODE(SetVectorRegister,                                   Void,           VectorReg,      U32,                                                            )
OPCODE(GetGotoVariable,                                     U1,             U32,                                                                            )
OPCODE(SetGotoVariable,                                     Void,           U32,            U1,                                                             )
OPCODE(GetAttribute,                                        F32,            Attribute,      U32,            U32,                                            )
OPCODE(GetAttributeU32,                                     U32,            Attribute,      U32,                                                            )
OPCODE(SetAttribute,                                        Void,           Attribute,      F32,            U32,                                            )
OPCODE(GetPatch,                                            F32,            Patch,                                                                          )
OPCODE(SetPatch,                                            Void,           Patch,          F32,                                                            )
OPCODE(GetTessGenericAttribute,                             F32,            U32,            U32,            U32,                                            )
OPCODE(SetTcsGenericAttribute,                              Void,           F32,            U32,            U32,                                            )
OPCODE(ReadTcsGenericOuputAttribute,                        F32,            U32,            U32,            U32,                                            )


// Flags
OPCODE(GetScc,                                              U1,             Void,                                                                           )
OPCODE(GetExec,                                             U1,             Void,                                                                           )
OPCODE(GetVcc,                                              U1,             Void,                                                                           )
OPCODE(GetVccLo,                                            U32,            Void,                                                                           )
OPCODE(GetVccHi,                                            U32,            Void,                                                                           )
OPCODE(GetM0,                                               U32,            Void,                                                                           )
OPCODE(SetScc,                                              Void,           U1,                                                                             )
OPCODE(SetExec,                                             Void,           U1,                                                                             )
OPCODE(SetVcc,                                              Void,           U1,                                                                             )
OPCODE(SetSccLo,                                            Void,           U32,                                                                            )
OPCODE(SetVccLo,                                            Void,           U32,                                                                            )
OPCODE(SetVccHi,                                            Void,           U32,                                                                            )
OPCODE(SetM0,                                               Void,           U32,                                                                            )

// Undefined
OPCODE(UndefU1,                                             U1,                                                                                             )
OPCODE(UndefU8,                                             U8,                                                                                             )
OPCODE(UndefU16,                                            U16,                                                                                            )
OPCODE(UndefU32,                                            U32,                                                                                            )
OPCODE(UndefU64,                                            U64,                                                                                            )

// Buffer operations
OPCODE(LoadBufferU8,                                        U8,             Opaque,         Opaque,                                                         )
OPCODE(LoadBufferU16,                                       U16,            Opaque,         Opaque,                                                         )
OPCODE(LoadBufferU32,                                       U32,            Opaque,         Opaque,                                                         )
OPCODE(LoadBufferU32x2,                                     U32x2,          Opaque,         Opaque,                                                         )
OPCODE(LoadBufferU32x3,                                     U32x3,          Opaque,         Opaque,                                                         )
OPCODE(LoadBufferU32x4,                                     U32x4,          Opaque,         Opaque,                                                         )
OPCODE(LoadBufferU64,                                       U64,            Opaque,         Opaque,                                                         )
OPCODE(LoadBufferF32,                                       F32,            Opaque,         Opaque,                                                         )
OPCODE(LoadBufferF32x2,                                     F32x2,          Opaque,         Opaque,                                                         )
OPCODE(LoadBufferF32x3,                                     F32x3,          Opaque,         Opaque,                                                         )
OPCODE(LoadBufferF32x4,                                     F32x4,          Opaque,         Opaque,                                                         )
OPCODE(LoadBufferFormatF32,                                 F32x4,          Opaque,         Opaque,                                                         )
OPCODE(StoreBufferU8,                                       Void,           Opaque,         Opaque,         U8,                                             )
OPCODE(StoreBufferU16,                                      Void,           Opaque,         Opaque,         U16,                                            )
OPCODE(StoreBufferU32,                                      Void,           Opaque,         Opaque,         U32,                                            )
OPCODE(StoreBufferU32x2,                                    Void,           Opaque,         Opaque,         U32x2,                                          )
OPCODE(StoreBufferU32x3,                                    Void,           Opaque,         Opaque,         U32x3,                                          )
OPCODE(StoreBufferU32x4,                                    Void,           Opaque,         Opaque,         U32x4,                                          )
OPCODE(StoreBufferU64,                                      Void,           Opaque,         Opaque,         U64,                                            )
OPCODE(StoreBufferF32,                                      Void,           Opaque,         Opaque,         F32,                                            )
OPCODE(StoreBufferF32x2,                                    Void,           Opaque,         Opaque,         F32x2,                                          )
OPCODE(StoreBufferF32x3,                                    Void,           Opaque,         Opaque,         F32x3,                                          )
OPCODE(StoreBufferF32x4,                                    Void,           Opaque,         Opaque,         F32x4,                                          )
OPCODE(StoreBufferFormatF32,                                Void,           Opaque,         Opaque,         F32x4,                                          )

// Buffer atomic operations
OPCODE(BufferAtomicIAdd32,                                  U32,            Opaque,         Opaque,         U32                                             )
OPCODE(BufferAtomicIAdd64,                                  U64,            Opaque,         Opaque,         U64                                             )
OPCODE(BufferAtomicISub32,                                  U32,            Opaque,         Opaque,         U32                                             )
OPCODE(BufferAtomicSMin32,                                  U32,            Opaque,         Opaque,         U32                                             )
OPCODE(BufferAtomicSMin64,                                  U64,            Opaque,         Opaque,         U64                                             )
OPCODE(BufferAtomicUMin32,                                  U32,            Opaque,         Opaque,         U32                                             )
OPCODE(BufferAtomicUMin64,                                  U64,            Opaque,         Opaque,         U64                                             )
OPCODE(BufferAtomicFMin32,                                  F32,            Opaque,         Opaque,         F32                                             )
OPCODE(BufferAtomicSMax32,                                  U32,            Opaque,         Opaque,         U32                                             )
OPCODE(BufferAtomicSMax64,                                  U64,            Opaque,         Opaque,         U64                                             )
OPCODE(BufferAtomicUMax32,                                  U32,            Opaque,         Opaque,         U32                                             )
OPCODE(BufferAtomicUMax64,                                  U64,            Opaque,         Opaque,         U64                                             )
OPCODE(BufferAtomicFMax32,                                  F32,            Opaque,         Opaque,         F32                                             )
OPCODE(BufferAtomicInc32,                                   U32,            Opaque,         Opaque,                                                         )
OPCODE(BufferAtomicDec32,                                   U32,            Opaque,         Opaque,                                                         )
OPCODE(BufferAtomicAnd32,                                   U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(BufferAtomicOr32,                                    U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(BufferAtomicXor32,                                   U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(BufferAtomicSwap32,                                  U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(BufferAtomicCmpSwap32,                               U32,            Opaque,         Opaque,         U32,            U32,                            )

// Vector utility
OPCODE(CompositeConstructU32x2,                             U32x2,          U32,            U32,                                                            )
OPCODE(CompositeConstructU32x3,                             U32x3,          U32,            U32,            U32,                                            )
OPCODE(CompositeConstructU32x4,                             U32x4,          U32,            U32,            U32,            U32,                            )
OPCODE(CompositeConstructU32x2x2,                           U32x4,          U32x2,          U32x2,                                                          )
OPCODE(CompositeExtractU32x2,                               U32,            U32x2,          U32,                                                            )
OPCODE(CompositeExtractU32x3,                               U32,            U32x3,          U32,                                                            )
OPCODE(CompositeExtractU32x4,                               U32,            U32x4,          U32,                                                            )
OPCODE(CompositeInsertU32x2,                                U32x2,          U32x2,          U32,            U32,                                            )
OPCODE(CompositeInsertU32x3,                                U32x3,          U32x3,          U32,            U32,                                            )
OPCODE(CompositeInsertU32x4,                                U32x4,          U32x4,          U32,            U32,                                            )
OPCODE(CompositeShuffleU32x2,                               U32x2,          U32x2,          U32x2,          U32,            U32,                            )
OPCODE(CompositeShuffleU32x3,                               U32x3,          U32x3,          U32x3,          U32,            U32,            U32,            )
OPCODE(CompositeShuffleU32x4,                               U32x4,          U32x4,          U32x4,          U32,            U32,            U32,            U32,            )
OPCODE(CompositeConstructF32x2,                             F32x2,          F32,            F32,                                                            )
OPCODE(CompositeConstructF32x3,                             F32x3,          F32,            F32,            F32,                                            )
OPCODE(CompositeConstructF32x4,                             F32x4,          F32,            F32,            F32,            F32,                            )
OPCODE(CompositeConstructF32x2x2,                           F32x4,          F32x2,          F32x2,                                                          )
OPCODE(CompositeExtractF32x2,                               F32,            F32x2,          U32,                                                            )
OPCODE(CompositeExtractF32x3,                               F32,            F32x3,          U32,                                                            )
OPCODE(CompositeExtractF32x4,                               F32,            F32x4,          U32,                                                            )
OPCODE(CompositeInsertF32x2,                                F32x2,          F32x2,          F32,            U32,                                            )
OPCODE(CompositeInsertF32x3,                                F32x3,          F32x3,          F32,            U32,                                            )
OPCODE(CompositeInsertF32x4,                                F32x4,          F32x4,          F32,            U32,                                            )
OPCODE(CompositeShuffleF32x2,                               F32x2,          F32x2,          F32x2,          U32,            U32,                            )
OPCODE(CompositeShuffleF32x3,                               F32x3,          F32x3,          F32x3,          U32,            U32,            U32,            )
OPCODE(CompositeShuffleF32x4,                               F32x4,          F32x4,          F32x4,          U32,            U32,            U32,            U32,            )

// Select operations
OPCODE(SelectU1,                                            U1,             U1,             U1,             U1,                                             )
OPCODE(SelectU32,                                           U32,            U1,             U32,            U32,                                            )
OPCODE(SelectF32,                                           F32,            U1,             F32,            F32,                                            )

// Bitwise conversions
OPCODE(BitCastU16F16,                                       U16,            F16,                                                                            )
OPCODE(BitCastU32F32,                                       U32,            F32,                                                                            )
OPCODE(BitCastF16U16,                                       F16,            U16,                                                                            )
OPCODE(BitCastF32U32,                                       F32,            U32,                                                                            )

OPCODE(PackUint2x32,                                        U64,            U32x2,                                                                          )
OPCODE(UnpackUint2x32,                                      U32x2,          U64,                                                                            )
OPCODE(PackDouble2x32,                                      F64,            U32x2,                                                                          )
OPCODE(UnpackDouble2x32,                                    U32x2,          F64,                                                                            )

OPCODE(PackUnorm2x16,                                       U32,            F32x2,                                                                          )
OPCODE(UnpackUnorm2x16,                                     F32x2,          U32,                                                                            )
OPCODE(PackSnorm2x16,                                       U32,            F32x2,                                                                          )
OPCODE(UnpackSnorm2x16,                                     F32x2,          U32,                                                                            )
OPCODE(PackUint2x16,                                        U32,            F32x2,                                                                          )
OPCODE(UnpackUint2x16,                                      F32x2,          U32,                                                                            )
OPCODE(PackSint2x16,                                        U32,            F32x2,                                                                          )
OPCODE(UnpackSint2x16,                                      F32x2,          U32,                                                                            )
OPCODE(PackHalf2x16,                                        U32,            F32x2,                                                                          )
OPCODE(UnpackHalf2x16,                                      F32x2,          U32,                                                                            )

OPCODE(PackUnorm4x8,                                        U32,            F32x4,                                                                          )
OPCODE(UnpackUnorm4x8,                                      F32x4,          U32,                                                                            )
OPCODE(PackSnorm4x8,                                        U32,            F32x4,                                                                          )
OPCODE(UnpackSnorm4x8,                                      F32x4,          U32,                                                                            )
OPCODE(PackUint4x8,                                         U32,            F32x4,                                                                          )
OPCODE(UnpackUint4x8,                                       F32x4,          U32,                                                                            )
OPCODE(PackSint4x8,                                         U32,            F32x4,                                                                          )
OPCODE(UnpackSint4x8,                                       F32x4,          U32,                                                                            )

OPCODE(PackUfloat10_11_11,                                  U32,            F32x3,                                                                          )
OPCODE(UnpackUfloat10_11_11,                                F32x3,          U32,                                                                            )

OPCODE(PackUnorm2_10_10_10,                                 U32,            F32x4,                                                                          )
OPCODE(UnpackUnorm2_10_10_10,                               F32x4,          U32,                                                                            )
OPCODE(PackSnorm2_10_10_10,                                 U32,            F32x4,                                                                          )
OPCODE(UnpackSnorm2_10_10_10,                               F32x4,          U32,                                                                            )
OPCODE(PackUint2_10_10_10,                                  U32,            F32x4,                                                                          )
OPCODE(UnpackUint2_10_10_10,                                F32x4,          U32,                                                                            )
OPCODE(PackSint2_10_10_10,                                  U32,            F32x4,                                                                          )
OPCODE(UnpackSint2_10_10_10,                                F32x4,          U32,                                                                            )

// Floating-point operations
OPCODE(FPAbs32,                                             F32,            F32,                                                                            )
OPCODE(FPAbs64,                                             F64,            F64,                                                                            )
OPCODE(FPAdd32,                                             F32,            F32,            F32,                                                            )
OPCODE(FPAdd64,                                             F64,            F64,            F64,                                                            )
OPCODE(FPSub32,                                             F32,            F32,            F32,                                                            )
OPCODE(FPFma32,                                             F32,            F32,            F32,            F32,                                            )
OPCODE(FPFma64,                                             F64,            F64,            F64,            F64,                                            )
OPCODE(FPMax32,                                             F32,            F32,            F32,            U1,                                             )
OPCODE(FPMax64,                                             F64,            F64,            F64,                                                            )
OPCODE(FPMin32,                                             F32,            F32,            F32,            U1,                                             )
OPCODE(FPMin64,                                             F64,            F64,            F64,                                                            )
OPCODE(FPMinTri32,                                          F32,            F32,            F32,            F32,                                            )
OPCODE(FPMaxTri32,                                          F32,            F32,            F32,            F32,                                            )
OPCODE(FPMedTri32,                                          F32,            F32,            F32,            F32,                                            )
OPCODE(FPMul32,                                             F32,            F32,            F32,                                                            )
OPCODE(FPMul64,                                             F64,            F64,            F64,                                                            )
OPCODE(FPDiv32,                                             F32,            F32,            F32,                                                            )
OPCODE(FPDiv64,                                             F64,            F64,            F64,                                                            )
OPCODE(FPNeg32,                                             F32,            F32,                                                                            )
OPCODE(FPNeg64,                                             F64,            F64,                                                                            )
OPCODE(FPRecip32,                                           F32,            F32,                                                                            )
OPCODE(FPRecip64,                                           F64,            F64,                                                                            )
OPCODE(FPRecipSqrt32,                                       F32,            F32,                                                                            )
OPCODE(FPRecipSqrt64,                                       F64,            F64,                                                                            )
OPCODE(FPSqrt,                                              F32,            F32,                                                                            )
OPCODE(FPSin,                                               F32,            F32,                                                                            )
OPCODE(FPExp2,                                              F32,            F32,                                                                            )
OPCODE(FPPow,                                               F32,            F32,            F32,                                                            )
OPCODE(FPLdexp,                                             F32,            F32,            U32,                                                            )
OPCODE(FPCos,                                               F32,            F32,                                                                            )
OPCODE(FPLog2,                                              F32,            F32,                                                                            )
OPCODE(FPSaturate32,                                        F32,            F32,                                                                            )
OPCODE(FPSaturate64,                                        F64,            F64,                                                                            )
OPCODE(FPClamp32,                                           F32,            F32,            F32,            F32,                                            )
OPCODE(FPClamp64,                                           F64,            F64,            F64,            F64,                                            )
OPCODE(FPRoundEven32,                                       F32,            F32,                                                                            )
OPCODE(FPRoundEven64,                                       F64,            F64,                                                                            )
OPCODE(FPFloor32,                                           F32,            F32,                                                                            )
OPCODE(FPFloor64,                                           F64,            F64,                                                                            )
OPCODE(FPCeil32,                                            F32,            F32,                                                                            )
OPCODE(FPCeil64,                                            F64,            F64,                                                                            )
OPCODE(FPTrunc32,                                           F32,            F32,                                                                            )
OPCODE(FPTrunc64,                                           F64,            F64,                                                                            )
OPCODE(FPFract32,                                           F32,            F32,                                                                            )
OPCODE(FPFract64,                                           F64,            F64,                                                                            )
OPCODE(FPFrexpSig32,                                        F32,            F32,                                                                            )
OPCODE(FPFrexpSig64,                                        F64,            F64,                                                                            )
OPCODE(FPFrexpExp32,                                        U32,            F32,                                                                            )
OPCODE(FPFrexpExp64,                                        U32,            F64,                                                                            )

OPCODE(FPOrdEqual32,                                        U1,             F32,            F32,                                                            )
OPCODE(FPOrdEqual64,                                        U1,             F64,            F64,                                                            )
OPCODE(FPUnordEqual32,                                      U1,             F32,            F32,                                                            )
OPCODE(FPUnordEqual64,                                      U1,             F64,            F64,                                                            )
OPCODE(FPOrdNotEqual32,                                     U1,             F32,            F32,                                                            )
OPCODE(FPOrdNotEqual64,                                     U1,             F64,            F64,                                                            )
OPCODE(FPUnordNotEqual32,                                   U1,             F32,            F32,                                                            )
OPCODE(FPUnordNotEqual64,                                   U1,             F64,            F64,                                                            )
OPCODE(FPOrdLessThan32,                                     U1,             F32,            F32,                                                            )
OPCODE(FPOrdLessThan64,                                     U1,             F64,            F64,                                                            )
OPCODE(FPUnordLessThan32,                                   U1,             F32,            F32,                                                            )
OPCODE(FPUnordLessThan64,                                   U1,             F64,            F64,                                                            )
OPCODE(FPOrdGreaterThan32,                                  U1,             F32,            F32,                                                            )
OPCODE(FPOrdGreaterThan64,                                  U1,             F64,            F64,                                                            )
OPCODE(FPUnordGreaterThan32,                                U1,             F32,            F32,                                                            )
OPCODE(FPUnordGreaterThan64,                                U1,             F64,            F64,                                                            )
OPCODE(FPOrdLessThanEqual32,                                U1,             F32,            F32,                                                            )
OPCODE(FPOrdLessThanEqual64,                                U1,             F64,            F64,                                                            )
OPCODE(FPUnordLessThanEqual32,                              U1,             F32,            F32,                                                            )
OPCODE(FPUnordLessThanEqual64,                              U1,             F64,            F64,                                                            )
OPCODE(FPOrdGreaterThanEqual32,                             U1,             F32,            F32,                                                            )
OPCODE(FPOrdGreaterThanEqual64,                             U1,             F64,            F64,                                                            )
OPCODE(FPUnordGreaterThanEqual32,                           U1,             F32,            F32,                                                            )
OPCODE(FPUnordGreaterThanEqual64,                           U1,             F64,            F64,                                                            )
OPCODE(FPIsNan32,                                           U1,             F32,                                                                            )
OPCODE(FPIsNan64,                                           U1,             F64,                                                                            )
OPCODE(FPIsInf32,                                           U1,             F32,                                                                            )
OPCODE(FPIsInf64,                                           U1,             F64,                                                                            )
OPCODE(FPCmpClass32,                                        U1,             F32,            U32                                                             )

// Integer operations
OPCODE(IAdd32,                                              U32,            U32,            U32,                                                            )
OPCODE(IAdd64,                                              U64,            U64,            U64,                                                            )
OPCODE(IAddCarry32,                                         U32x2,          U32,            U32,                                                            )
OPCODE(ISub32,                                              U32,            U32,            U32,                                                            )
OPCODE(ISub64,                                              U64,            U64,            U64,                                                            )
OPCODE(IMul32,                                              U32,            U32,            U32,                                                            )
OPCODE(IMul64,                                              U64,            U64,            U64,                                                            )
OPCODE(SMulHi,                                              U32,            U32,            U32,                                                            )
OPCODE(UMulHi,                                              U32,            U32,            U32,                                                            )
OPCODE(SDiv32,                                              U32,            U32,            U32,                                                            )
OPCODE(UDiv32,                                              U32,            U32,            U32,                                                            )
OPCODE(SMod32,                                              U32,            U32,            U32,                                                            )
OPCODE(UMod32,                                              U32,            U32,            U32,                                                            )
OPCODE(INeg32,                                              U32,            U32,                                                                            )
OPCODE(INeg64,                                              U64,            U64,                                                                            )
OPCODE(IAbs32,                                              U32,            U32,                                                                            )
OPCODE(ShiftLeftLogical32,                                  U32,            U32,            U32,                                                            )
OPCODE(ShiftLeftLogical64,                                  U64,            U64,            U32,                                                            )
OPCODE(ShiftRightLogical32,                                 U32,            U32,            U32,                                                            )
OPCODE(ShiftRightLogical64,                                 U64,            U64,            U32,                                                            )
OPCODE(ShiftRightArithmetic32,                              U32,            U32,            U32,                                                            )
OPCODE(ShiftRightArithmetic64,                              U64,            U64,            U32,                                                            )
OPCODE(BitwiseAnd32,                                        U32,            U32,            U32,                                                            )
OPCODE(BitwiseAnd64,                                        U64,            U64,            U64,                                                            )
OPCODE(BitwiseOr32,                                         U32,            U32,            U32,                                                            )
OPCODE(BitwiseOr64,                                         U64,            U64,            U64,                                                            )
OPCODE(BitwiseXor32,                                        U32,            U32,            U32,                                                            )
OPCODE(BitFieldInsert,                                      U32,            U32,            U32,            U32,            U32,                            )
OPCODE(BitFieldSExtract,                                    U32,            U32,            U32,            U32,                                            )
OPCODE(BitFieldUExtract,                                    U32,            U32,            U32,            U32,                                            )
OPCODE(BitReverse32,                                        U32,            U32,                                                                            )
OPCODE(BitCount32,                                          U32,            U32,                                                                            )
OPCODE(BitCount64,                                          U32,            U64,                                                                            )
OPCODE(BitwiseNot32,                                        U32,            U32,                                                                            )

OPCODE(FindSMsb32,                                          U32,            U32,                                                                            )
OPCODE(FindUMsb32,                                          U32,            U32,                                                                            )
OPCODE(FindUMsb64,                                          U32,            U64,                                                                            )
OPCODE(FindILsb32,                                          U32,            U32,                                                                            )
OPCODE(FindILsb64,                                          U32,            U64,                                                                            )
OPCODE(SMin32,                                              U32,            U32,            U32,                                                            )
OPCODE(UMin32,                                              U32,            U32,            U32,                                                            )
OPCODE(SMax32,                                              U32,            U32,            U32,                                                            )
OPCODE(UMax32,                                              U32,            U32,            U32,                                                            )
OPCODE(SMinTri32,                                           U32,            U32,            U32,            U32,                                            )
OPCODE(UMinTri32,                                           U32,            U32,            U32,            U32,                                            )
OPCODE(SMaxTri32,                                           U32,            U32,            U32,            U32,                                            )
OPCODE(UMaxTri32,                                           U32,            U32,            U32,            U32,                                            )
OPCODE(SMedTri32,                                           U32,            U32,            U32,            U32,                                            )
OPCODE(UMedTri32,                                           U32,            U32,            U32,            U32,                                            )
OPCODE(SClamp32,                                            U32,            U32,            U32,            U32,                                            )
OPCODE(UClamp32,                                            U32,            U32,            U32,            U32,                                            )
OPCODE(SLessThan32,                                         U1,             U32,            U32,                                                            )
OPCODE(SLessThan64,                                         U1,             U64,            U64,                                                            )
OPCODE(ULessThan32,                                         U1,             U32,            U32,                                                            )
OPCODE(ULessThan64,                                         U1,             U64,            U64,                                                            )
OPCODE(IEqual32,                                            U1,             U32,            U32,                                                            )
OPCODE(IEqual64,                                            U1,             U64,            U64,                                                            )
OPCODE(SLessThanEqual32,                                    U1,             U32,            U32,                                                            )
OPCODE(SLessThanEqual64,                                    U1,             U64,            U64,                                                            )
OPCODE(ULessThanEqual32,                                    U1,             U32,            U32,                                                            )
OPCODE(ULessThanEqual64,                                    U1,             U64,            U64,                                                            )
OPCODE(SGreaterThan32,                                      U1,             U32,            U32,                                                            )
OPCODE(SGreaterThan64,                                      U1,             U64,            U64,                                                            )
OPCODE(UGreaterThan32,                                      U1,             U32,            U32,                                                            )
OPCODE(UGreaterThan64,                                      U1,             U64,            U64,                                                            )
OPCODE(INotEqual32,                                         U1,             U32,            U32,                                                            )
OPCODE(INotEqual64,                                         U1,             U64,            U64,                                                            )
OPCODE(SGreaterThanEqual32,                                 U1,             U32,            U32,                                                            )
OPCODE(SGreaterThanEqual64,                                 U1,             U64,            U64,                                                            )
OPCODE(UGreaterThanEqual32,                                 U1,             U32,            U32,                                                            )
OPCODE(UGreaterThanEqual64,                                 U1,             U64,            U64,                                                            )

// Logical operations
OPCODE(LogicalOr,                                           U1,             U1,             U1,                                                             )
OPCODE(LogicalAnd,                                          U1,             U1,             U1,                                                             )
OPCODE(LogicalXor,                                          U1,             U1,             U1,                                                             )
OPCODE(LogicalNot,                                          U1,             U1,                                                                             )

// Conversion operations
OPCODE(ConvertS32F32,                                       U32,            F32,                                                                            )
OPCODE(ConvertS32F64,                                       U32,            F64,                                                                            )
OPCODE(ConvertU32F32,                                       U32,            F32,                                                                            )
OPCODE(ConvertF16F32,                                       F16,            F32,                                                                            )
OPCODE(ConvertF32F16,                                       F32,            F16,                                                                            )
OPCODE(ConvertF32F64,                                       F32,            F64,                                                                            )
OPCODE(ConvertF64F32,                                       F64,            F32,                                                                            )
OPCODE(ConvertF32S32,                                       F32,            U32,                                                                            )
OPCODE(ConvertF32U32,                                       F32,            U32,                                                                            )
OPCODE(ConvertF64S32,                                       F64,            U32,                                                                            )
OPCODE(ConvertF64U32,                                       F64,            U32,                                                                            )
OPCODE(ConvertF32U16,                                       F32,            U16,                                                                            )
OPCODE(ConvertU16U32,                                       U16,            U32,                                                                            )
OPCODE(ConvertU32U16,                                       U32,            U16,                                                                            )
OPCODE(ConvertU8U32,                                        U8,             U32,                                                                            )
OPCODE(ConvertU32U8,                                        U32,            U8,                                                                             )
OPCODE(ConvertS32S8,                                        U32,            U8,                                                                             )
OPCODE(ConvertS32S16,                                       U32,            U16,                                                                            )

// Image operations
OPCODE(ImageSampleRaw,                                      F32x4,          Opaque,         Opaque,         F32x4,          F32x4,          F32x4,          F32,           )
OPCODE(ImageSampleImplicitLod,                              F32x4,          Opaque,         F32x4,          F32,            Opaque,                         )
OPCODE(ImageSampleExplicitLod,                              F32x4,          Opaque,         Opaque,         F32,            Opaque,                         )
OPCODE(ImageSampleDrefImplicitLod,                          F32x4,          Opaque,         Opaque,         F32,            F32,            Opaque,         )
OPCODE(ImageSampleDrefExplicitLod,                          F32x4,          Opaque,         Opaque,         F32,            F32,            Opaque,         )
OPCODE(ImageGather,                                         F32x4,          Opaque,         Opaque,         Opaque,                                         )
OPCODE(ImageGatherDref,                                     F32x4,          Opaque,         Opaque,         Opaque,         F32,                            )
OPCODE(ImageQueryDimensions,                                U32x4,          Opaque,         U32,            U1,                                             )
OPCODE(ImageQueryLod,                                       F32x4,          Opaque,         Opaque,                                                         )
OPCODE(ImageGradient,                                       F32x4,          Opaque,         Opaque,         Opaque,         Opaque,         Opaque,         F32,          )
OPCODE(ImageRead,                                           F32x4,          Opaque,         Opaque,         U32,            U32,                            )
OPCODE(ImageWrite,                                          Void,           Opaque,         Opaque,         U32,            U32,            F32x4,          )

// Image atomic operations
OPCODE(ImageAtomicIAdd32,                                   U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(ImageAtomicSMin32,                                   U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(ImageAtomicUMin32,                                   U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(ImageAtomicSMax32,                                   U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(ImageAtomicUMax32,                                   U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(ImageAtomicFMax32,                                   F32,            Opaque,         Opaque,         F32,                                            )
OPCODE(ImageAtomicFMin32,                                   F32,            Opaque,         Opaque,         F32,                                            )
OPCODE(ImageAtomicInc32,                                    U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(ImageAtomicDec32,                                    U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(ImageAtomicAnd32,                                    U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(ImageAtomicOr32,                                     U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(ImageAtomicXor32,                                    U32,            Opaque,         Opaque,         U32,                                            )
OPCODE(ImageAtomicExchange32,                               U32,            Opaque,         Opaque,         U32,                                            )

// Cube operations - optional, usable if profile.supports_native_cube_calc
OPCODE(CubeFaceIndex,                                       F32,            F32x3,                                                                          )

// Warp operations
OPCODE(LaneId,                                              U32,                                                                                            )
OPCODE(WarpId,                                              U32,                                                                                            )
OPCODE(QuadShuffle,                                         U32,            U32,            U32                                                             )
OPCODE(ReadFirstLane,                                       U32,            U32,                                                                            )
OPCODE(ReadLane,                                            U32,            U32,            U32                                                             )
OPCODE(WriteLane,                                           U32,            U32,            U32,            U32                                             )
OPCODE(Ballot,                                              U32x4,          U1,                                                                             )
OPCODE(BallotFindLsb,                                       U32,            U32x4,                                                                          )
OPCODE(DataAppend,                                          U32,            U32,            U32                                                             )
OPCODE(DataConsume,                                         U32,            U32,            U32                                                             )
OPCODE(GroupAny,                                            U1,             U1,                                                                             )
