const os = require('os')

// this is required to satisfy electron-builder's ${os} file macros
// https://www.electron.build/file-patterns#file-macros
function convertPlatform(platform) {
  if (platform === 'darwin') {
    return 'mac'
  } else if (platform === 'win32') {
    return 'win'
  } else {
    return platform
  }
}

module.exports =
  require(`@termius/node-pty/${convertPlatform(os.platform())}-${os.arch()}/pty.node`)
