/*****************************************************************************
 * css_bridge.h : CSS grammar/lexer bridge
 *****************************************************************************
 * Copyright (C) 2017 VideoLabs, VLC authors and VideoLAN
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/
#define yyconst const
#define YYSTYPE CSSSTYPE
typedef void* yyscan_t;
typedef struct yy_buffer_state *YY_BUFFER_STATE;
int csslex_init (yyscan_t* scanner);
YY_BUFFER_STATE css_scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE css_scan_bytes (yyconst char *bytes, int, yyscan_t yyscanner );
int csslex_destroy (yyscan_t yyscanner );
void css_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner);
